<?php
/* --------------------------------------------------------------
  InfoElementContentToThemeJsonConverter.php 2019-12-06
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

use Gambio\StyleEdit\Core\Mapper\Exceptions\AliasNotFoundException;

/**
 * Class InfoElementContentToThemeJsonConverter
 */
class InfoElementContentToThemeJsonConverter implements InfoElementContentToThemeJsonConverterInterface
{
    
    /**
     * @inheritDoc
     * @throws AliasNotFoundException
     */
    public function convert(InfoElementContent $content): stdClass
    {
        if ($content->id()->contentAlias() === null) {
            
            throw new AliasNotFoundException($content->id()->contentGroup());
        }
        
        return (object)[
            'alias'    => $content->id()->contentAlias(),
            'type'     => $content->type(),
            'position' => $content->position(),
            'status'   => (string)(int)$content->isActive(),
            'title'    => $content->titles(),
            'heading'  => $this->headingContent($content->headings()),
            'text'     => $content->texts()
        ];
    }
    
    
    /**
     * @param ContentHeadingCollection $headings
     *
     * @return stdClass
     */
    protected function headingContent(ContentHeadingCollection $headings): stdClass
    {
        $result = new stdClass;
    
        foreach ($headings as $heading) {
            
            /** @var ContentHeading $heading */
            $result->{$heading->languageCode()} = $heading->content();
        }
        
        
        return $result;
    }
}